/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftpbrowser;

import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftpbrowser.FtpBrowserApplet;
import com.quantumdata.std.QDUtil;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.Scrollable;

public class FileEditor
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private CoFile m_file;
    private JEditorPane m_editor;
    private JProgressBar m_progBar;
    private JButton m_cancelButton;
    private boolean m_isCanceled = false;
    private boolean m_isImage = false;
    private boolean m_validImage = false;
    private RenderedImage m_renderedImg = null;
    private BufferedInputStream m_imgStream = null;
    private String m_errorMsg = "ERROR";
    private int m_scale = 1;

    public FileEditor(CoFile coFile) {
        super(coFile.getAbsolutePath());
        JComponent jComponent;
        JScrollPane jScrollPane;
        this.setDefaultCloseOperation(2);
        this.m_file = coFile;
        String[] stringArray = new String[]{".BMP", ".JPG", ".GIF", ".PNG"};
        if (coFile.equalsExtTo(stringArray)) {
            this.m_isImage = true;
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(3, 3));
        if (!this.m_isImage) {
            this.m_editor = new JEditorPane();
            this.m_editor.setFont(new Font("Dialog", 1, 10));
            this.m_editor.setForeground(Color.BLACK);
            this.m_editor.setCaretColor(Color.YELLOW);
            this.m_editor.setBackground(Color.WHITE);
            jScrollPane = new JScrollPane(this.m_editor);
        } else {
            jComponent = new JToolBar();
            ImageIcon imageIcon = QDUtil.createAppletImageIcon("images/ZoomIn.gif", FtpBrowserApplet.class);
            JButton jButton = new JButton(imageIcon);
            jButton.setActionCommand("ZOOM-IN");
            jButton.addActionListener(this);
            jButton.setMnemonic(521);
            jButton.setToolTipText("Magnify x 2");
            jComponent.add(jButton);
            imageIcon = QDUtil.createAppletImageIcon("images/ZoomOut.gif", FtpBrowserApplet.class);
            jButton = new JButton(imageIcon);
            jButton.setActionCommand("ZOOM-OUT");
            jButton.addActionListener(this);
            jButton.setMnemonic(45);
            jButton.setToolTipText("Magnify x 0.5");
            jComponent.add(jButton);
            container.add((Component)jComponent, "North");
            Image image = this.createImage(coFile);
            ImagePanel imagePanel = new ImagePanel(image);
            jScrollPane = new JScrollPane(imagePanel);
        }
        container.add((Component)jScrollPane, "Center");
        jComponent = new JPanel(new BorderLayout(10, 3));
        int n = (int)this.m_file.length();
        this.m_progBar = new JProgressBar(0, n > 0 ? n : 0);
        this.m_progBar.setStringPainted(true);
        this.m_progBar.setVisible(false);
        jComponent.add((Component)this.m_progBar, "Center");
        this.m_cancelButton = new JButton("Cancel");
        this.m_cancelButton.setActionCommand("CANCEL");
        this.m_cancelButton.addActionListener(this);
        this.m_cancelButton.setVisible(false);
        jComponent.add((Component)this.m_cancelButton, "East");
        container.add((Component)jComponent, "South");
        this.setSize(300, 300);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        if (!this.m_isImage) {
            new Thread(new FileReader()).start();
        }
    }

    public Image createImage(CoFile coFile) {
        BufferedInputStream bufferedInputStream;
        if (coFile.equalsExtTo(".BMP")) {
            try {
                this.m_imgStream = new BufferedInputStream(coFile.getInputStream());
                ImageDecoder imageDecoder = ImageCodec.createImageDecoder("bmp", this.m_imgStream, null);
                if (imageDecoder == null) {
                    this.m_errorMsg = "*** Unable to create BMP Decoder ***";
                    this.m_imgStream.close();
                    return null;
                }
                this.m_renderedImg = imageDecoder.decodeAsRenderedImage();
                if (this.m_renderedImg == null) {
                    this.m_errorMsg = "*** Failed to decode the BMP image ***";
                    this.m_imgStream.close();
                    return null;
                }
            }
            catch (Exception exception) {
                this.m_errorMsg = "Error: " + exception.getMessage();
                return null;
            }
            this.m_validImage = true;
            return null;
        }
        try {
            bufferedInputStream = new BufferedInputStream(coFile.getInputStream());
        }
        catch (IOException iOException) {
            this.m_errorMsg = "Error: " + iOException.getMessage();
            return null;
        }
        if (bufferedInputStream != null) {
            int n = (int)coFile.length();
            byte[] byArray = new byte[n];
            try {
                int n2;
                int n3;
                int n4 = 0;
                while ((n3 = bufferedInputStream.read(byArray, n4, n2 = n - n4 >= 1024 ? 1024 : n - n4)) > 0) {
                    n4 += n3;
                }
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                this.m_errorMsg = "Read Error: " + iOException.getMessage();
            }
            this.m_validImage = true;
            return Toolkit.getDefaultToolkit().createImage(byArray);
        }
        this.m_errorMsg = "Couldn't find file: " + coFile.getAbsolutePath();
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("CANCEL")) {
            this.m_isCanceled = true;
        }
        if (actionEvent.getActionCommand().equals("ZOOM-IN")) {
            ++this.m_scale;
            this.pack();
            this.repaint();
        }
        if (actionEvent.getActionCommand().equals("ZOOM-OUT")) {
            --this.m_scale;
            if (this.m_scale < 1) {
                this.m_scale = 1;
            }
            this.pack();
            this.repaint();
        }
    }

    class ImagePanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 1L;
        private Image m_image;

        public ImagePanel(Image image) {
            this.m_image = image;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        public Dimension getPreferredScrollableViewportSize() {
            Rectangle rectangle = this.getVisibleRect();
            return new Dimension(rectangle.width, rectangle.height);
        }

        public Dimension getPreferredSize() {
            if (FileEditor.this.m_validImage) {
                if (FileEditor.this.m_renderedImg != null) {
                    return new Dimension(FileEditor.this.m_renderedImg.getWidth() * FileEditor.this.m_scale, FileEditor.this.m_renderedImg.getHeight() * FileEditor.this.m_scale);
                }
                return new Dimension(this.m_image.getWidth(this) * FileEditor.this.m_scale, this.m_image.getHeight(this) * FileEditor.this.m_scale);
            }
            return new Dimension(300, 100);
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 50;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        protected void paintComponent(Graphics graphics) {
            if (!FileEditor.this.m_validImage) {
                graphics.drawString(FileEditor.this.m_errorMsg, 10, 10);
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(FileEditor.this.m_scale, FileEditor.this.m_scale);
            if (FileEditor.this.m_renderedImg != null) {
                graphics2D.drawRenderedImage(FileEditor.this.m_renderedImg, affineTransform);
                if (FileEditor.this.m_imgStream != null) {
                    try {
                        FileEditor.this.m_imgStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    FileEditor.this.m_imgStream = null;
                }
            } else {
                graphics2D.drawImage(this.m_image, affineTransform, this);
            }
        }
    }

    private class FileReader
    implements Runnable {
        private FileReader() {
        }

        public void run() {
            FileEditor.this.m_isCanceled = false;
            FileEditor.this.m_cancelButton.setVisible(true);
            FileEditor.this.m_progBar.setVisible(true);
            FileEditor.this.m_progBar.setValue(0);
            FileEditor.this.m_progBar.setString("0 of " + FileEditor.this.m_file.length());
            byte[] byArray = new byte[1024];
            String string = new String(" of " + FileEditor.this.m_file.length());
            StringBuffer stringBuffer = new StringBuffer(4096);
            try {
                int n;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(FileEditor.this.m_file.getInputStream());
                int n2 = 0;
                while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0 && !FileEditor.this.m_isCanceled) {
                    FileEditor.this.m_progBar.setString((n2 += n) + string);
                    FileEditor.this.m_progBar.setValue(n2);
                    stringBuffer.append(new String(byArray, 0, n));
                }
                bufferedInputStream.close();
                FileEditor.this.m_editor.setText(stringBuffer.toString());
            }
            catch (Exception exception) {
                FileEditor.this.m_editor.setText("ERROR: " + exception.getMessage());
            }
            if (!FileEditor.this.m_isCanceled) {
                FileEditor.this.m_progBar.setVisible(false);
            }
            FileEditor.this.m_cancelButton.setVisible(false);
        }
    }
}

